/********************************************************************
 FileName:		interuption.c
 ********************************************************************/

/** INCLUDES *******************************************************/
#include "math.h"

#include "include/Compiler.h"
#include "include/GenericTypeDefs.h"
#include "HardwareProfile.h"

#include "ax12.h"
#include "interuption.h"

/** D E F I N E S ************************************************************/
#define temps_pente	23		// X * 43.69ms, X=23 => 1s
#define kP			0.015	// coeficient du terme proportionel
#define kI			0.015	// coeficient du terme integral
#define kD			10	// coeficient du terme driv
#define interval_RPM_OK 10.0	// interval pour les RPM stable
#define limite_moteur_arrete 109	// limite basse des overflow du timer1 pour considerer le moteur comme arrt
									// 100 corespond a des RPM<100, voir le fichier excel "calcul des RPM" 
#define limite_I	10000.0	// limite pour le terme integrale
#define dt	0.005	// periode de la regulation

/** V A R I A B L E S ********************************************************/
#pragma udata

// calcul des RPM
WORD 	RPM;									// RPM actuel
WORD 	valeur_TMR1;							// valeur du TMR1 au moment de l'overflow 
WORD_VAL valeur_TMR1_temp;						// valeur temporaire pour le mode 8bits
WORD 	overflow_TMR1;							// nbre d'overflow avant top du capteur RPM

// regul
extern char mode;								// mode actuel
int 	tab_erreur[5] = {0};				// tableau d'erreurs 
WORD 	consigne;								// consigne selon le mode
float som_erreur=0, diff_erreur=0;	// calcul des termes de l'integrale et de la deriv
int 	commande_AX12;						// commande de position du servomoteur
WORD_VAL commande_AX12_temp;					// valeur temporaire pour l'emission en mode 8bits
BOOL	etat_moteur;							// tat du moteur, ON/OFF
long P=0, I=0, D=0;
float temporaire;
float temporaire2;

// gestion du servo
char 	Speedhight[3] = { 0x20, 0xFF, 0x03 };	// vitesse haute
char 	Speedmed[3] = { 0x20, 0xFF, 0x01 };		// vitesse moyenne
char 	Speedlow[3] = { 0x20, 0xF0, 0x00 };		// vitesse basse
char 	position_0[3] = { 0x1E, 0x00, 0x00 };	// position 0
char 	compteur = 0;							// compteur pour la pente

// Arret d'urgence
BOOL	AU = 0;									// flag de l'arret d'urgence

/** D E C L A R A T I O N S **************************************************/
#pragma code

// ****************************************
// interuption sur front montant du capteur RPM
// ****************************************
void capteur(void)
{
	mLED_5=1;
    
	T1CONbits.TMR1ON = 0;	// arrete le TIMER1
	valeur_TMR1_temp.LB = TMR1L;	// recupere la valeur du TIMER1
	valeur_TMR1_temp.HB = TMR1H;	
	valeur_TMR1 = valeur_TMR1_temp.Val;
	TMR1L = 0;				// reset le timer1
	TMR1H = 0;				
	T1CONbits.TMR1ON = 1;	// lancer le TIMER1
	RPM = 720000000 / (valeur_TMR1 + (overflow_TMR1 * 65535));	// calcul des RPM

if (overflow_TMR1>limite_moteur_arrete) 
{
	etat_moteur=FALSE;	// moteur arrt
	RPM=0;				// pour eviter les RPM fou
}
else etat_moteur=TRUE;	// sinon c'est que le moteur tourne
overflow_TMR1 = 0;		// reset le compteur d'overflow

	mLED_5=0;
}


// ****************************************
// interuption pour le calcul des RPM, nbre d'overflow en plus
// ****************************************
void TIMER1(void)
{
	overflow_TMR1++;		// indique le nombre d'overflow du timer pour la mesure de RPM

// pour eviter que sa reste bloqu a la derniere valeur au dessu de la limite
if (overflow_TMR1>limite_moteur_arrete+100) 
{
	etat_moteur=FALSE;	// moteur arrt
	RPM=0;				// pour debloquer les RPM
}
}


// ****************************************
// interuption pour la periode de rgulation
// ****************************************
void TIMER0(void)
{
	char i;
	char ax12env[3];
	
	mLED_6=1;

// test si l'arret d'urgence a t enclench
if (AU == 0)
{
// test du mode en cour, ne s'occupe de la regulation qu'en mode automatique
if ((mode==MANU_AUTO)||(mode==AUTO))
{
// gestion regulation
	for(i=5;i>=1;i--) tab_erreur[i]=tab_erreur[i-1];// sauvegarde de l'ancienne erreur, tableau FIFO

	tab_erreur[0] = consigne - RPM;					// calcul de la nouvelle erreur
	temporaire = 0;
	temporaire =som_erreur;
	temporaire2 = (tab_erreur[0])*dt;
	som_erreur = temporaire + (tab_erreur[0])*dt;		// effectue la somme des erreurs depuis le debut
	if (som_erreur>=limite_I) som_erreur=(float)limite_I;	// limite le terme de l'integral
	if (som_erreur<=(-limite_I)) som_erreur=-(float)limite_I;	// limite le terme de l'integral
//	diff_erreur = (tab_erreur[0] - tab_erreur[4])/dt;	// calcul la difference entre l'erreur precedente et l'actuel
/*
	P = kP * tab_erreur[0];							// calcul le terme proportionel
	I = kI * som_erreur;							// calcul le terme integrale
	D = kD * diff_erreur;							// calcul le terme driv

// si il faut changer la commande, sinon si les RPM sont dans l'interval pas de changement
//if ( fabs(consigne - RPM) > interval_RPM_OK) 
commande_AX12 += P + I + D;	// rsultat final
*/
}

// vrifie les bornes de la commande
if(commande_AX12 >= 1023) commande_AX12 = 1023;
if(commande_AX12 <= 1) commande_AX12 = 1;

// envoi la commande
commande_AX12_temp.Val = commande_AX12;
ax12env[0] = 0x1E;
ax12env[1] = commande_AX12_temp.LB;
ax12env[2] = commande_AX12_temp.HB;
AX_TxPacket(0x01, I_WRITE_DATA, ax12env, 3);

} // fin de test de l'AU

	mLED_6=0;
} // fin de l'interuption


// ****************************************
// interuption pour la fin de la pente ralentit lors de changement de mode pour eviter des acoups
// ****************************************
void TIMER3(void)
{
	mLED_7=1;

compteur++;
// temps de la pente
	if(compteur==temps_pente)	
	{
		T3CONbits.TMR3ON = 0;	// timer3 OFF
		PIE2bits.TMR3IE = 0;	// devalide interuption Timer3
		AX_TxPacket(0x01, I_WRITE_DATA, Speedhight, 3);
		compteur=0;
	}
	mLED_7=0;
}


// ****************************************
// interuption pour le mode Arret d'Urgence
// ****************************************
void INT0(void)
{
// tester si c le premier passage
if (AU==FALSE)
{
	mLED_8=1;
	AX_TxPacket(0x01, I_WRITE_DATA, position_0, 3);	// mettre la commande de l'ax12 a 0
	INTCON2bits.INTEDG2 = 0;						// interuption sur front descendant de INT2
	AU=TRUE;
}
else
{
	INTCON2bits.INTEDG2 = 1;						// interuption sur front montant de INT2
	AU=FALSE;
	mLED_8=0;
}
}

/** EOF interuption.c ***************************************************************/
